//=============================================================================
// GameStuff.js
//=============================================================================

/*:
 * @plugindesc Testing Video Stuff
 * @author Tilmann Hars
 *
 * @help This plugin does not provide plugin commands.
 */

/*:ja
 * @plugindesc メニュー画面のレイアウトを変更します。
 * @author Yoji Ojima
 *
 * @help このプラグインには、プラグインコマンドはありません。
 */

(function() {
	var _oldbgmvolume;
	Graphics._createVideo = function() {
	    this._video = document.createElement('video');
	    this._video.id = 'GameVideo';
	    this._video.style.opacity = 0;
	    this._updateVideo();
	    document.body.appendChild(this._video);
	};

	Graphics._onVideoLoad = function() {
		if (!_oldbgmvolume)
		{
			_oldbgmvolume = AudioManager._bgmVolume;
			AudioManager.bgmVolume = AudioManager.bgmVolume/8;
		}
	    this._video.play();
	    this._video.style.opacity = 1;
	    this._canvas.style.opacity = 1;
	};

    Graphics._updateVideo = function() {
        this._video.width = 288;
        this._video.height = 192;
        this._video.style.zIndex = 2;
        var element = this._video;
        var width = element.width * this._realScale;
        var height = element.height * this._realScale;
        element.style.position = 'absolute';
        // element.style.margin = 'auto';
        element.style.top = 0;
        element.style.left = 0;
        element.style.right = 0;
        element.style.bottom = 0;
        element.style.width = width + 'px';
        element.style.height = height + 'px';
        // this._centerElement(this._video);
    };

    Graphics._readjustAudio = function()
    {
    	if (_oldbgmvolume)
    	{
    		AudioManager.bgmVolume = _oldbgmvolume;
    		_oldbgmvolume = null;
    	}
    }

    Graphics._stopVideo = function() {

        if (this._video && document.body.contains(this._video))
        {
            this._video.pause();
            // document.body.removeChild(this._video);
            this._video.style.opacity = 0;
            Graphics._readjustAudio();
            
        }
    }

    Game_Interpreter.prototype.command261 = function() {
        if (!$gameMessage.isBusy()) {
            var name = this._params[0];
            var size = this._params[0]
            if (name.length > 0) {
                var ext = this.videoFileExt();
                Graphics.playVideo('movies/' + name + ext);
                this.setWaitMode('video');
            }
            this._index++;
        }
        return false;
    };


})();
